package api_test

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"github.com/gorilla/mux"
	"github.com/stretchr/testify/require"

	"code.justin.tv/lifecycle/vienna/api"
)

func TestHealth(t *testing.T) {
	r := mux.NewRouter()
	a := api.NewApi(api.Config{}, &api.NullStatter{})
	a.SetupRoutes(r)

	req, _ := http.NewRequest("GET", "/health", nil)
	rr := httptest.NewRecorder()
	r.ServeHTTP(rr, req)

	require.Equal(t, 200, rr.Code)
	require.Equal(t, "OK", rr.Body.String())
}

func TestTwirpBadRoute(t *testing.T) {
	r := mux.NewRouter()
	a := api.NewApi(api.Config{}, &api.NullStatter{})
	a.SetupRoutes(r)

	req, _ := http.NewRequest("GET", "/twirp/foobar", nil)
	rr := httptest.NewRecorder()
	r.ServeHTTP(rr, req)

	require.Equal(t, 404, rr.Code)
	require.Contains(t, rr.Body.String(), "bad_route")
}
