package api

import (
	"net/http"
	"os"
	"path/filepath"
)

func (a *Api) ServeStaticAssets(w http.ResponseWriter, r *http.Request) {
	indexPath := filepath.Join(a.conf.STATIC_ASSETS_DIR, a.conf.STATIC_ASSETS_INDEX)

	// Serve index at the root
	if r.URL.Path == "/" {
		a.stats.Inc("RequestStatic.IndexPage", 1)
		http.ServeFile(w, r, indexPath)
		return
	}

	// Validate path
	path, err := filepath.Abs(r.URL.Path) // absolute path to prevent directory traversal
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)
		return
	}

	// Check if file exists
	filePath := filepath.Join(a.conf.STATIC_ASSETS_DIR, path)
	_, err = os.Stat(filePath)
	if os.IsNotExist(err) {
		// If file does not exist, repond with index.html.
		// This is important, the JavaScript/React router will handle the route,
		// routes like: /oauth/callback#access_token=xxx need to be handled in the frontend,
		// if the route is not found, the React router will show a proper error in the UI.
		SkipRequestLog(r) // do not log access tokens
		http.ServeFile(w, r, indexPath)
		return
	}
	if err != nil {
		http.Error(w, err.Error(), http.StatusInternalServerError) // filesystem error
		return
	}

	// Serve the file as a static asset
	SkipRequestLog(r) // keep access logs clean off .css and .js files
	a.fileServer.ServeHTTP(w, r)
}
