package api_test

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"github.com/gorilla/mux"
	"github.com/stretchr/testify/require"

	"code.justin.tv/lifecycle/vienna/api"
)

func TestServeStaticAssets(t *testing.T) {
	r := mux.NewRouter()
	a := api.NewApi(api.Config{
		STATIC_ASSETS_DIR:   "./", // relative to current dir
		STATIC_ASSETS_INDEX: "api.go",
	}, &api.NullStatter{})
	a.SetupRoutes(r)

	// Load root index page
	req, _ := http.NewRequest("GET", "/", nil)
	rr := httptest.NewRecorder()
	r.ServeHTTP(rr, req)
	require.Equal(t, 200, rr.Code)
	require.Contains(t, rr.Body.String(), "type Api struct") // check it is the right file

	// Load another file that exists
	req, _ = http.NewRequest("GET", "/api_test.go", nil)
	rr = httptest.NewRecorder()
	r.ServeHTTP(rr, req)
	require.Equal(t, 200, rr.Code)
	require.Contains(t, rr.Body.String(), "package api_test") // check it is the right file

	// Route to a file that does not exist should return the index page
	req, _ = http.NewRequest("GET", "/foobar/otherroute?token=blahblahblah", nil)
	rr = httptest.NewRecorder()
	r.ServeHTTP(rr, req)
	require.Equal(t, 200, rr.Code)
	require.Contains(t, rr.Body.String(), "type Api struct") // check it is the right file
}
