import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as easymode from '@twitch/easymode';

export interface InterfaceVpcEndpointStackProps extends cdk.StackProps {
  vpc: ec2.IVpc;
  service: ec2.IInterfaceVpcEndpointService;
  domainName: string;
}

export class InterfaceVpcEndpointStack extends cdk.Stack {
  constructor(scope: cdk.Construct, name: string, props: InterfaceVpcEndpointStackProps) {
    super(scope, name, props);

    const endpoint = new easymode.PrivateLinkEndpoint(this, 'endpoint', {
      vpc: props.vpc,
      service: props.service,
      hostedZones: [{ zoneName: props.domainName }],
    });

    const port = props.service.port;
    endpoint.connections.allowFromAnyIpv4(
      new ec2.Port({
        stringRepresentation: port.toString(),
        protocol: ec2.Protocol.TCP,
        fromPort: port,
        toPort: port,
      }),
    );
  }
}
