import decode from 'jwt-decode';
import { JwtData } from './models/jwt-data';
import { onAppLoadSetup } from 'bouncer-auth-js';
// https://git-aws.internal.justin.tv/twilight/bouncer-auth-js

export const BOUNCER_KEY = 'Bouncer.Jwt.Vienna';

export function setupAuth() {
  let auth: JwtData | null = null;

  const token = onAppLoadSetup(BOUNCER_KEY);
  if (token) {
    auth = decode<JwtData>(token);
  }

  return auth;
}

export function extractRoles(roles: string[]) {
  const roleNames = roles.map(role => {
    const parts = role.split(':');
    const partCount = parts.length;

    return parts[partCount - 1];
  });

  return roleNames;
}
