import React from 'react';
import { ViennaFormField } from '~core/components/vienna-form/models/form-model';
import { CheckBox } from 'twitch-core-ui';

export interface PublicProps {
  formField: ViennaFormField;
  value: boolean;
  onChange: (
    eventOrPath: string | React.ChangeEvent<any>,
  ) => void | ((eventOrTextValue: string | React.ChangeEvent<any>) => void);
  onBlur: (eventOrString: any) => void | ((e: any) => void);
}

type Props = PublicProps;

export const ViennaBooleanInputField: React.FC<Props> = props => {
  return (
    <CheckBox
      label={props.formField.displayName}
      checked={props.value}
      onChange={props.onChange}
      onBlur={props.onBlur}
    />
  );
};
