import React from 'react';
import { ViennaFormField } from '~core/components/vienna-form/models/form-model';
import { FormGroup, Select } from 'twitch-core-ui';

export interface PublicProps {
  formField: ViennaFormField;
  value: string;
  onChange: (
    eventOrPath: string | React.ChangeEvent<any>,
  ) => void | ((eventOrTextValue: string | React.ChangeEvent<any>) => void);
  onBlur: (eventOrString: any) => void | ((e: any) => void);
}

type Props = PublicProps;

export const ViennaSelectForminput: React.FC<Props> = props => {
  return (
    <FormGroup label={props.formField.displayName}>
      <Select value={props.value} onChange={props.onChange} onBlur={props.onBlur}>
        {props.formField.selectOptions &&
          props.formField.selectOptions.map((optionValue, index) => (
            <option value={optionValue.value.toString()} key={index}>
              {optionValue.display}
            </option>
          ))}
      </Select>
    </FormGroup>
  );
};
