import React from 'react';
import { InputType, Input, FormGroup } from 'twitch-core-ui';
import { ViennaFormField } from '~core/components/vienna-form/models/form-model';

export interface PublicProps {
  formField: ViennaFormField;
  value: string;
  onChange: (
    eventOrPath: string | React.ChangeEvent<any>,
  ) => void | ((eventOrTextValue: string | React.ChangeEvent<any>) => void);
  onBlur: (eventOrString: any) => void | ((e: any) => void);
}

type Props = PublicProps;

export const ViennaStringFormInput: React.FC<Props> = props => {
  return (
    <FormGroup label={props.formField.displayName}>
      <Input
        type={InputType.Text}
        value={props.value}
        id={props.formField.name}
        name={props.formField.name}
        onChange={props.onChange}
      />
    </FormGroup>
  );
};
