import React, { useContext } from 'react';
import { UserContext } from '~features/user-context';
import { InferableComponentDecorator } from 'formik';
import { ViennaLDAPRoles } from '~core/components/with-authorization/roles';
import { Redirect } from 'react-router';

export interface AuthorizationProps {
  role: string;
  behavior?: UnauthorizedBehavior;
}

export enum UnauthorizedBehavior {
  Hide = 'hide',
  Redirect = 'redirect',
}

export function withAuthorization<P>(
  authProps: AuthorizationProps,
): InferableComponentDecorator<P> {
  return (WrappedComponent: React.ComponentType) => {
    const WithAuthorization = (props: P) => {
      const { LDAPRoles } = useContext(UserContext);
      console.log('roles', LDAPRoles);

      if (!authProps.role) {
        return <WrappedComponent {...props} />;
      }

      if (LDAPRoles.includes(authProps.role)) {
        return <WrappedComponent {...props} />;
      }

      if (LDAPRoles.includes(ViennaLDAPRoles.AllAccess)) {
        return <WrappedComponent {...props} />;
      }

      if (authProps.behavior) {
        if (authProps.behavior === UnauthorizedBehavior.Redirect) {
          return <Redirect to="/unauthorized" />;
        }
      }

      return null;
    };

    return WithAuthorization as any;
  };
}
