import { JwtData } from './models/jwt-data';

export function isJwtValidTime(payload: JwtData, timeVariance = 300): boolean {
  const nbfMs = (payload.nbf - timeVariance) * 1000;
  const iatMs = (payload.iat - timeVariance) * 1000;
  const expMs = (payload.exp + timeVariance) * 1000;
  const nowMs = Date.now();

  return nbfMs <= nowMs && iatMs <= nowMs && expMs > nowMs;
}
