import { DateTime } from 'luxon';

export function formatIsoAsDatetimeMed(isoDateStr: string): string {
  if (isoDateStr === '') {
    return 'N/A';
  }
  let dt = DateTime.fromISO(isoDateStr);
  return dt.toLocaleString(DateTime.DATETIME_MED) || 'N/A';
}

export function formatTimestampAsYearMonthDay(timestamp?: string): string {
  if (!timestamp) {
    return '';
  }
  const dt = DateTime.fromJSDate(new Date(timestamp));
  return dt.toFormat('yyyy/MM/dd');
}
