import { createBrowserHistory, History } from 'history';
import { Config } from '~core/models/config';
import { KrakenClient } from '~core/clients/kraken/client';
import {
  RBAC,
  RBACActionHistory,
  RBACAdmin,
  ExtensionReviews,
} from '~core/clients/rbac/code.justin.tv.devrel';
import { TwitchE2IngestHTTP } from '~core/clients/twitch-e2-ingest-http/twitch.fulton.example';
import { fetchWithAuth } from '~core/clients/fetch-with-auth';
import {
  InMemoryCache,
  IntrospectionFragmentMatcher,
  NormalizedCacheObject,
} from 'apollo-cache-inmemory';
import { HttpLink } from 'apollo-link-http';
import ApolloClient from 'apollo-client';
import fragmentData from '~core/graphql/fragmentTypes.json';
import 'twitch-core-ui/css/index-light-fallback.css';
import 'react-toastify/dist/ReactToastify.css';
import './styles.scss';

export let history: History;
export let config: Config;
export let krakenClient: KrakenClient;
export let RBACClient: RBAC;
export let RBACActionHistoryClient: RBACActionHistory;
export let RBACAdminClient: RBACAdmin;
export let ExtensionReviewClient: ExtensionReviews;
export let TwitchE2IngestHTTPClient: TwitchE2IngestHTTP;
export let apolloClient: ApolloClient<NormalizedCacheObject>;

export function startVienna(c: Config, edgeHost: string) {
  config = c;
  history = createBrowserHistory();

  krakenClient = new KrakenClient(config.urls.kraken, config.tokens.krakenClientId);
  RBACClient = new RBAC(edgeHost, fetchWithAuth);
  RBACActionHistoryClient = new RBACActionHistory(edgeHost, fetchWithAuth);
  RBACAdminClient = new RBACAdmin(edgeHost, fetchWithAuth);
  ExtensionReviewClient = new ExtensionReviews(edgeHost, fetchWithAuth);
  TwitchE2IngestHTTPClient = new TwitchE2IngestHTTP(edgeHost, fetchWithAuth);
  apolloClient = createApolloClient(config);
}

function createApolloClient(config: Config) {
  const fragmentMatcher = new IntrospectionFragmentMatcher({
    introspectionQueryResultData: fragmentData,
  });
  const link = new HttpLink({
    uri: config.urls.gql,
    headers: {
      'Client-ID': config.tokens.krakenClientId,
    },
  });

  const client = new ApolloClient<NormalizedCacheObject>({
    link,
    cache: new InMemoryCache({ fragmentMatcher }),
  });

  return client;
}
