import React, { useState } from 'react';
import { ModalId, Modal } from 'tachyon-modal';
import { Game } from '~features/game-autocomplete/models/game';
import { ModalHeader, Layout, BoxArtCard, ModalFooter, FormGroup } from 'twitch-core-ui';
import { GameAutocomplete } from '~features/game-autocomplete';
import './styles.scss';
import { AutocompleteChildProps } from '~features/autocomplete/autocomplete';

export interface PublicProps {
  active: boolean;
  id: ModalId;
  closeModal: () => void;
  onClose: (game: Game) => void;
}

type Props = PublicProps;

export const AddGameModal: React.FC<Props> = (props) => {
  const [game, setGame] = useState<Game | undefined>();

  function closeModal() {
    if (game) {
      props.onClose(game);
    }

    props.closeModal();
  }

  return (
    <Modal id={props.id}>
      <ModalHeader
        title="Add Game"
        closeButton={{ onClick: props.closeModal, 'aria-label': 'Close' }}
      />
      <Layout padding={{ x: 3, y: 2 }} className="add-game-modal">
        <FormGroup label="Search Game">
          <GameAutocomplete onGameSelect={setGame} child={boxArtCard} />
        </FormGroup>
      </Layout>
      <ModalFooter
        primaryButtonProps={{ onClick: closeModal, disabled: !game, children: 'Add Game' }}
        secondaryButtonProps={{ onClick: props.closeModal, children: 'Cancel' }}
      />
    </Modal>
  );
};

const boxArtCard = (props: AutocompleteChildProps<Game>) => {
  const game = props.selectedItem;
  if (game) {
    return (
      <Layout margin={{ top: 2 }}>
        <BoxArtCard
          info={game.displayName}
          src={game.boxArtURL || ''}
          title={game.displayName}
          alt={game.boxArtURL || ''}
        />
      </Layout>
    );
  }
  return <></>;
};
