import React, { useContext, useEffect, useCallback } from 'react';
import { Button, Layout, Display, JustifyContent } from 'twitch-core-ui';
import { stringify } from 'query-string';
import { config } from '~core/vienna';
import { UserContext } from '~features/user-context/user-context';
import { fetchWithAuth, authHeaderValue } from '~core/clients/fetch-with-auth';

export const AuthenticationBanner: React.FC = () => {
  const { twitchToken: token, setTwitchToken: setToken } = useContext(UserContext);

  async function validateToken() {
    if (token) {
      const authResponse = await fetchWithAuth('https://id.twitch.tv/oauth2/validate', {
        headers: {
          Authorization: authHeaderValue(token),
        },
      });

      if (!authResponse.ok) {
        setToken(undefined);
      }
    }
  }

  const validateTokenCallback = useCallback(validateToken, [token, setToken]);

  useEffect(() => {
    validateTokenCallback();
  }, [validateTokenCallback]);

  if (token) {
    return null;
  }

  const params = stringify({
    client_id: config.clientId,
    redirect_uri: window.location.origin + config.oauth.callbackPath, // e.g. "https://vienna.xarth.tv/oauth/callback"
    response_type: 'token',
  });

  const url = `https://id.twitch.tv/oauth2/authorize?${params}`;

  return (
    <Layout fullWidth display={Display.Flex} justifyContent={JustifyContent.Center}>
      <Button linkTo={url}>Authenticate with Twitch</Button>
    </Layout>
  );
};
