import React from 'react';
import { ModalId, Modal } from 'tachyon-modal';
import {
  ModalHeader,
  ModalBody,
  Layout,
  Display,
  JustifyContent,
  AlignItems,
  ModalFooter,
} from 'twitch-core-ui';

export interface PublicProps {
  id: ModalId;
  closeModal: () => void;
  active: boolean;
  onClose: (confirm: boolean) => void;
  text: string;
}

type Props = PublicProps;

export const ConfirmationDialog: React.FC<Props> = (props) => {
  function closeModal() {
    props.onClose(false);
    props.closeModal();
  }

  function confirm() {
    props.onClose(true);
    props.closeModal();
  }

  return (
    <Modal id={props.id}>
      <ModalHeader
        title="Hey! Listen!"
        closeButton={{ 'aria-label': 'Close', onClick: closeModal }}
      />
      <ModalBody>
        <Layout
          display={Display.Flex}
          justifyContent={JustifyContent.Center}
          alignItems={AlignItems.Center}
        >
          {props.text}
        </Layout>
      </ModalBody>
      <ModalFooter
        primaryButtonProps={{ onClick: confirm, children: 'Confirm' }}
        secondaryButtonProps={{ onClick: props.closeModal, children: 'Cancel' }}
      />
    </Modal>
  );
};
