import React, { useCallback, useEffect, useState } from 'react';
import { EntityProps } from '~features/entity-list';
import { listExtensions_extensions_edges_node } from '~core/graphql/twitch-gql-schema';
import { TableRow, TableCell, ButtonType, Button } from 'twitch-core-ui';
import { krakenClient } from '~core/vienna';
import { toast } from 'react-toastify';

type Props = EntityProps<listExtensions_extensions_edges_node>;

export const ExtensionListItem: React.FC<Props> = (props) => {
  const [hasReport, setHasReport] = useState(false);

  async function reportsAvailable() {
    if (!props.item.clientID) {
      return;
    }

    const url = `/v5/piper/report/extensions/${props.item.clientID}`;
    const result = await krakenClient.get(url);
    const reportTypes = result.json?.report_type?.report_types;
    if (reportTypes && reportTypes.includes('overview_v2')) {
      setHasReport(true);
    }
  }

  const reportsAvailableCallback = useCallback(reportsAvailable, [props.item.clientID]);

  useEffect(() => {
    reportsAvailableCallback();
  }, [reportsAvailableCallback, props.item.clientID]);

  async function downloadReport() {
    const url = `/v5/piper/report/extensions/${props.item.clientID}/overview_v2/latest`;
    const { status, json: downloadURL, errorMessage } = await krakenClient.get(url);
    if (status === 200) {
      window.location = downloadURL;
    } else {
      toast(`Error downloading report: ${errorMessage}`, { type: 'error' });
    }
  }

  return (
    <TableRow>
      <TableCell>{props.item.name}</TableCell>
      <TableCell>{props.item.clientID}</TableCell>
      <TableCell>{props.item.authorName}</TableCell>
      <TableCell>
        <Button type={ButtonType.Secondary} disabled={!hasReport} onClick={downloadReport}>
          Download
        </Button>
      </TableCell>
    </TableRow>
  );
};
