import React, { useState, useContext } from 'react';
import * as ReactModal from 'react-modal';

export interface ModalContextStore {
  isOpen: boolean;
  component?: React.ComponentType;
  props?: any;
  close: () => void;
  open: (component: React.ComponentType, props: any) => void;
}

export const ModalContext = React.createContext<ModalContextStore>({
  isOpen: false,
  component: undefined,
  close: () => null,
  open: () => null,
});

export const ModalContextProvider: React.FC = props => {
  const [isOpen, setOpen] = useState(false);
  const [modalComponent, setModalComponent] = useState<React.ComponentType | undefined>(undefined);
  const [modalProps, setModalProps] = useState<any>(undefined);

  function close() {
    setOpen(false);
    setModalComponent(undefined);
    setModalProps(undefined);
  }

  function open(component: React.ComponentType, props: any) {
    setModalProps(props);
    setModalComponent(component);
    setOpen(true);
  }

  return (
    <ModalContext.Provider
      value={{ open: open, isOpen: isOpen, close: close, component: modalComponent, props: modalProps }}
    >
      <>
        {props.children}
        <ModalRoot />
      </>
    </ModalContext.Provider>
  );
};

export const ModalRoot: React.FC = () => {
  const { isOpen, component: ModalContentComponent, props: modalprops } = useContext(ModalContext);

  if (!ModalContentComponent) {
    return null;
  }

  return (
    <ReactModal isOpen={isOpen}>{ModalContentComponent ? <ModalContentComponent {...modalprops} /> : null}</ReactModal>
  );
};
