import React from 'react';
import { DeveloperApplication } from '~core/clients/rbac/code.justin.tv.devrel';
import { TableRow, TableCell, Interactable, Button, ButtonType } from 'twitch-core-ui';
import { useModal } from 'tachyon-modal';
import { DeveloperApplicationModal } from '~features/organization-developer-applications/components/developer-application-modal/developer-application-modal';
import { formatIsoAsDatetimeMed } from '~core/utils/format-date';

export interface PublicProps {
  application: DeveloperApplication;
  onOnboard: (applicationId: string, role: string) => void;
  onRemove: (applicationId: string) => void;
}

type Props = PublicProps;

export const OrganizationDeveloperApplicationItem: React.FC<Props> = (props) => {
  const { active, id, closeModal, openModal } = useModal();

  function removeApplication() {
    props.onRemove(props.application.id);
  }

  return (
    <>
      <TableRow>
        <TableCell>
          <Interactable onClick={openModal}>
            {`${props.application.firstName} ${props.application.lastName}`}
          </Interactable>
        </TableCell>
        <TableCell>{props.application.title}</TableCell>
        <TableCell>{props.application.email}</TableCell>
        <TableCell>{props.application.emailVerificationStatus}</TableCell>
        <TableCell>{props.application.twitchId}</TableCell>
        <TableCell>{formatIsoAsDatetimeMed(props.application.createdAt)}</TableCell>
        <TableCell>
          <Button type={ButtonType.Alert} onClick={removeApplication}>
            Remove
          </Button>
        </TableCell>
      </TableRow>
      <DeveloperApplicationModal
        modalId={id}
        active={active}
        closeModal={closeModal}
        developer={props.application}
        onClose={props.onOnboard}
      />
    </>
  );
};
