import React from 'react';
import { TableRow, TableCell, CoreLink } from 'twitch-core-ui';
import { CompanyType } from '~features/organizations/models/organization-type';
import { Company } from '~core/clients/rbac/code.justin.tv.devrel';
import { EntityProps } from '~features/entity-list/entity-list';
import { formatIsoAsDatetimeMed } from '~core/utils/format-date';

export interface PublicProps {}

type Props = PublicProps & EntityProps<Company>;

export const OrganizationListItem: React.FC<Props> = (props) => {
  return (
    <TableRow>
      <TableCell>
        <CoreLink linkTo={`/organizations/${props.item.id}`}>{props.item.companyName}</CoreLink>
      </TableCell>
      <TableCell>{props.item.id}</TableCell>
      <TableCell>{formatIsoAsDatetimeMed(props.item.createdAt)}</TableCell>
      <TableCell>{CompanyType[(props.item.type as number) || 3]}</TableCell>
    </TableRow>
  );
};
