import React from 'react';
import {
  Layout,
  CoreText,
  StyledLayout,
  Color,
  Interactable,
  InteractableType,
  FontWeight,
} from 'twitch-core-ui';

export interface PublicProps {
  title: string;
  linkTo: string;
}

type Props = PublicProps;

export const Categoryitem: React.FC<Props> = props => {
  return (
    <StyledLayout
      className="category-section-item"
      margin={{ x: 1 }}
      color={Color.Alt}
    >
      <Interactable linkTo={props.linkTo} type={InteractableType.Alpha}>
        <Layout padding={1}>
          <CoreText fontWeight={FontWeight.SemiBold}>{props.title}</CoreText>
        </Layout>
      </Interactable>
    </StyledLayout>
  );
};
