import React, { useState } from 'react';
import {
  Layout,
  Display,
  CoreLink,
  CoreText,
  TextType,
  Interactable,
  StyledLayout,
  Background,
  AlignItems,
  Position,
  DropDownMenu,
  DropDownMenuItem,
  CoreLinkType,
} from 'twitch-core-ui';
import './styles.scss';
import { getJwtProperty } from 'bouncer-auth-js';
import { remove as removeCookie } from 'js-cookie';
import { ClickOutDetector } from '~core/components/click-out-detector';

export const TopBar: React.FC = () => {
  const [dropdownOpen, setDropdownOpen] = useState(false);

  function onLogout() {
    removeCookie('bouncer_auth');
    removeCookie('vienna_auth_token');
    window.location.reload();
  }

  return (
    <StyledLayout
      fullWidth
      className="top-bar"
      display={Display.Flex}
      alignItems={AlignItems.Center}
      background={Background.Base}
      padding={{ x: 2 }}
      position={Position.Fixed}
    >
      <CoreText type={TextType.H4}>
        <CoreLink linkTo="/" type={CoreLinkType.Inherit} hoverColorInherit={true}>
          Vienna
        </CoreLink>
      </CoreText>
      <Layout margin={{ left: 'auto' }} position={Position.Relative}>
        <ClickOutDetector onClickOut={() => setDropdownOpen(false)}>
          <Interactable hover={false} onClick={() => setDropdownOpen(!dropdownOpen)}>
            <Layout padding={{ x: 2 }}>{getJwtProperty('bouncer_auth', 'name')}</Layout>
          </Interactable>
          <DropDownMenu show={dropdownOpen}>
            <DropDownMenuItem label="Logout" onClick={onLogout} />
          </DropDownMenu>
        </ClickOutDetector>
      </Layout>
    </StyledLayout>
  );
};
