import React from 'react';
import { Layout } from 'twitch-core-ui';
import { Switch, Route } from 'react-router';
import { OrganizationRootPage } from '~pages/organization-root';
import { OAuthCallbackPage } from '~pages/oauth-callback-page';
import { GamesRootPage } from '~pages/games-root';
import { ExtensionsRootPage } from '~pages/extensions-root';
import { UnauthorizedPage } from '~pages/unauthorized';
import { E2RootPage } from '~pages/e2-root/e2-root-page';

export interface PublicProps {}

type Props = PublicProps;

export const RootRouter: React.FC<Props> = () => {
  return (
    <Switch>
      <Route exact path="/" component={IndexPage} />
      <Route path="/oauth/callback" component={OAuthCallbackPage} />
      <Route path="/organizations" component={OrganizationRootPage} />
      <Route path="/games" component={GamesRootPage} />
      <Route path="/extensions" component={ExtensionsRootPage} />
      <Route path="/e2" component={E2RootPage} />
      <Route path="/unauthorized" component={UnauthorizedPage} />
    </Switch>
  );
};

export const IndexPage: React.FC<Props> = () => {
  return (
    <Layout margin={2} fullHeight>
      <img src="https://i1.trekearth.com/photos/5043/schonbrunn_palace.jpg" />
    </Layout>
  );
};
