import React from 'react';
import { Layout, Title, TitleSize, CoreText } from 'twitch-core-ui';

export interface PublicProps {
  title: string;
  value: string | React.ReactChild;
  marginTop?: 0 | 1 | 2 | 3 | 4;
  marginBottom?: 0 | 1 | 2 | 3 | 4;
}

type Props = PublicProps;

export const InfoField: React.FC<Props> = (props) => {
  return (
    <Layout margin={{ top: props.marginTop || 1, bottom: props.marginBottom || 1 }}>
      <Layout margin={{ bottom: 0.5 }}>
        <Title size={TitleSize.ExtraSmall}>{props.title}</Title>
      </Layout>
      {typeof props.value === 'object' && props.value}
      {typeof props.value === 'string' && <CoreText>{props.value}</CoreText>}
    </Layout>
  );
};
