import React from 'react';
import { ExtensionReviewLog } from '~core/clients/rbac/code.justin.tv.devrel';
import { TableRow, TableCell, Layout } from 'twitch-core-ui';
import { formatIsoAsDatetimeMed } from '~core/utils/format-date';
import './styles.scss';

export interface PublicProps {
  log: ExtensionReviewLog;
}

type Props = PublicProps;

export const ExtensionReviewLogItem: React.FC<Props> = (props) => {
  const { log } = props;
  return (
    <TableRow>
      <TableCell>{formatIsoAsDatetimeMed(log.createdAt)}</TableCell>
      <TableCell>{log.extensionVersion}</TableCell>
      <TableCell>{log.state}</TableCell>
      <TableCell>{log.authorTwitchId}</TableCell>
      <TableCell>
        <Layout className="review-log-item__notes">{log.authorNotes}</Layout>
      </TableCell>
      <TableCell>{log.authorChannel}</TableCell>
      <TableCell>{log.reviewerTwitchId}</TableCell>
      <TableCell>{log.reviewReason}</TableCell>
      <TableCell>{log.reviewReasonCodes.join(', ')}</TableCell>
      <TableCell>{log.salesforceCaseId}</TableCell>
    </TableRow>
  );
};
