import React from 'react';
import { Layout } from 'twitch-core-ui';
import { Switch, Route } from 'react-router';
import { ExtensionsListPage } from '~pages/extensions-list';
import { ExtensionRootEntry } from '~pages/extensions-root/extensions-entry';
import { ExtensionsReviewPage } from '~pages/extensions-review';
import { withAuthorization, UnauthorizedBehavior } from '~core/components/with-authorization';
import { ViennaLDAPRoles } from '~core/components/with-authorization/roles';

export const ExtensionsRootPageComponent: React.FC = () => {
  return (
    <Layout margin={2} fullHeight>
      <Switch>
        <Route
          path="/extensions/:clientId/:version/review"
          component={ExtensionsReviewPage}
          exact
        />
        <ExtensionRootEntry>
          <Route path="/extensions" component={ExtensionsListPage} exact />
        </ExtensionRootEntry>
      </Switch>
    </Layout>
  );
};

export const ExtensionsRootPage = withAuthorization({
  role: ViennaLDAPRoles.BaseAccess,
  behavior: UnauthorizedBehavior.Redirect,
})(ExtensionsRootPageComponent);
