import React from 'react';
import {
  Layout,
  Display,
  JustifyContent,
  Button,
  ButtonType,
  AlignItems,
  BoxArtCard,
  Grid,
  Column,
  StyledLayout,
  Background,
  CoreText,
  FormGroup,
  CoreLink,
} from 'twitch-core-ui';
import { getGameDetails_game } from '~core/graphql/twitch-gql-schema';
import { PageHeader } from '~features/page-header';
import { GameApplication, Company } from '~core/clients/rbac/code.justin.tv.devrel';

export interface PublicProps {
  game: getGameDetails_game;
  application: GameApplication;
  company: Company;
  owningCompany?: Company;
  onApprove: () => void;
  onReject: () => void;
}

type Props = PublicProps;

export const GamesReviewDetailPresentation: React.FC<Props> = (props) => {
  return (
    <Layout margin={{ bottom: 2 }}>
      <Layout
        display={Display.Flex}
        justifyContent={JustifyContent.Between}
        alignItems={AlignItems.Center}
      >
        <PageHeader title={props.game.displayName} />
        <Layout display={Display.Flex}>
          <Layout margin={{ right: 1 }}>
            <Button type={ButtonType.Alert} onClick={props.onReject}>
              Reject
            </Button>
          </Layout>
          <Button type={ButtonType.Primary} onClick={props.onApprove}>
            Accept
          </Button>
        </Layout>
      </Layout>
      <Layout>
        <Grid>
          <Column cols={3}>
            <BoxArtCard
              src={props.game.boxArtURL || ''}
              title={props.game.displayName}
              info=""
              alt=""
            />
          </Column>
          <Column cols={9}>
            <StyledLayout background={Background.Base} padding={2}>
              <Layout margin={{ bottom: 2 }}>
                <FormGroup label="Company">
                  <CoreLink linkTo={`/organizations/${props.company.id}`}>
                    <CoreText>{props.company.companyName}</CoreText>
                  </CoreLink>
                </FormGroup>
              </Layout>
              {props.owningCompany && (
                <Layout margin={{ bottom: 2 }}>
                  <FormGroup label="Owning Company">
                    <CoreLink linkTo={`/organizations/${props.owningCompany.id}`}>
                      <CoreText>{props.owningCompany.companyName}</CoreText>
                    </CoreLink>
                  </FormGroup>
                </Layout>
              )}
              <Layout>
                <FormGroup label="External Link">
                  <CoreLink
                    targetBlank
                    linkTo={`https:/www.giantbomb.com/games/3030-${props.game.giantBombID}`}
                  >
                    Giant Bomb
                  </CoreLink>
                </FormGroup>
              </Layout>
            </StyledLayout>
          </Column>
        </Grid>
      </Layout>
    </Layout>
  );
};
