import React from 'react';
import { Layout } from 'twitch-core-ui';
import { Switch, Route } from 'react-router';
import { GamesListPage } from '~pages/games-list';
import { GameReviewListPage } from '~pages/games-review-list';
import { GamesRootEntry } from '~pages/games-root/games-root-entry';
import { GamesReviewDetailPage } from '~pages/games-review-detail';
import { withAuthorization, UnauthorizedBehavior } from '~core/components/with-authorization';
import { ViennaLDAPRoles } from '~core/components/with-authorization/roles';

export const GamesRootPageComponent: React.FC = () => {
  return (
    <Layout padding={2} fullWidth fullHeight>
      <Switch>
        <Route path="/games/review/:gameApplicationId" component={GamesReviewDetailPage} />
        <GamesRootEntry>
          <Route path="/games" component={GamesListPage} exact />
          <Route path="/games/review" component={GameReviewListPage} exact />
        </GamesRootEntry>
      </Switch>
    </Layout>
  );
};

export const GamesRootPage = withAuthorization({
  role: ViennaLDAPRoles.BaseAccess,
  behavior: UnauthorizedBehavior.Redirect,
})(GamesRootPageComponent);
