import React, { useContext } from 'react';
import { Redirect, useLocation } from 'react-router';
import { parse } from 'query-string';
import { UserContext } from '~features/user-context';
import * as cookie from 'js-cookie';

export const OAuthCallbackPage: React.FC = () => {
  const location = useLocation();
  const { setTwitchToken: setToken } = useContext(UserContext);
  const params = parse(location.hash);

  if (params.access_token) {
    setToken(params.access_token as string);
    cookie.set('vienna_auth_token', params.access_token);
  }

  return <Redirect to="/" />;
};
