import { AllowlistEntry } from '~core/clients/twitch-e2-ingest-http/twitch.fulton.example';
import {
  StyledLayout,
  Display,
  JustifyContent,
  AlignItems,
  Background,
  Layout,
  Table,
  TableHeader,
  TableRow,
  TableHeading,
  TableBody,
} from 'twitch-core-ui';
import React from 'react';
import { E2ListItem } from '~features/e2/list/components/e2-list-item/e2-list-item';

export interface PublicProps {
  entries: AllowlistEntry[];
  onEditEntry: (entry: AllowlistEntry) => void;
  onDeleteEntry: (entry: AllowlistEntry) => void;
}

type Props = PublicProps;

export const OrganizationE2Presentation: React.FC<Props> = (props) => {
  if (!props.entries || !props.entries.length) {
    return (
      <StyledLayout
        padding={{ y: 4 }}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
        alignItems={AlignItems.Center}
        background={Background.Alt2}
      >
        This Company has no E2 Clients
      </StyledLayout>
    );
  }
  return (
    <Layout>
      <Table>
        <TableHeader>
          <TableRow>
            <TableHeading label="Client ID" />
            <TableHeading label="Game ID" />
            <TableHeading label="Game Name" />
            <TableHeading label="Product" />
            <TableHeading label="Date Created" />
            <TableHeading label="Created By" />
            <TableHeading label="Actions" />
          </TableRow>
        </TableHeader>
        <TableBody>
          {props.entries.map((entry, index) => {
            return (
              <E2ListItem
                item={entry}
                key={index}
                onEditEntry={props.onEditEntry}
                onDeleteEntry={props.onDeleteEntry}
              />
            );
          })}
        </TableBody>
      </Table>
    </Layout>
  );
};
