import React, { useCallback, useEffect } from 'react';
import { useParams } from 'react-router';
import { RBACClient } from '~core/vienna';
import { ListResourcesRequest } from '~core/clients/rbac/code.justin.tv.devrel';
import { toast } from 'react-toastify';

interface RouteProps {
  organizationId: string;
}

export const OrganizationExtensionsPage: React.FC = () => {
  const { organizationId } = useParams<RouteProps>();

  async function fetchExtensions() {
    try {
      const result = await RBACClient.listResources(
        new ListResourcesRequest({
          companyId: organizationId,
          resourceType: 'extension',
          limit: 100,
        }),
      );

      console.log(result);
    } catch {
      toast('Error fetching extensions', { type: 'error' });
    }
  }

  const fetchExtensionsCallback = useCallback(fetchExtensions, [organizationId]);

  useEffect(() => {
    fetchExtensionsCallback();
  }, [organizationId, fetchExtensionsCallback]);

  return <></>;
};
