import React from 'react';
import {
  Layout,
  Display,
  JustifyContent,
  AlignItems,
  StyledLayout,
  Background,
  TableHeader,
  TableRow,
  TableHeading,
  Table,
  TableBody,
} from 'twitch-core-ui';
import { Game } from '~core/clients/rbac/code.justin.tv.devrel';
import { OrganizationGamesItem } from '~features/organizations-games/organization-games-item';

export interface PublicProps {
  games: Game[];
  onActivityModal: (gameId: string) => void;
  onRemoveGame: (gameId: number) => void;
}

type Props = PublicProps;

export const OrganizationGamesPresentation: React.FC<Props> = props => {
  if (!props.games || !props.games.length) {
    return (
      <StyledLayout
        padding={{ y: 4 }}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
        alignItems={AlignItems.Center}
        background={Background.Alt2}
      >
        This Company has no Games
      </StyledLayout>
    );
  }
  return (
    <Layout>
      <Table>
        <TableHeader>
          <TableRow>
            <TableHeading label="ID" />
            <TableHeading label="Name" />
            <TableHeading label="Giant Bomb ID" />
            <TableHeading label="Actions" />
          </TableRow>
        </TableHeader>
        <TableBody>
          {props.games.map((game, index) => {
            return (
              <OrganizationGamesItem
                game={game}
                key={index}
                onActivityModal={props.onActivityModal}
                onRemoveGame={props.onRemoveGame}
              />
            );
          })}
        </TableBody>
      </Table>
    </Layout>
  );
};
