import React, { useState, useCallback, useEffect } from 'react';
import { useParams } from 'react-router';
import { EntityList } from '~features/entity-list';
import { GameApplication, Id } from '~core/clients/rbac/code.justin.tv.devrel';
import { GameReviewListItem } from '~features/games/review/components/game-review-list-item';
import { RBACClient } from '~core/vienna';

export interface RouteProps {
  organizationId: string;
}

export const OrganizationPendingGamePage: React.FC = () => {
  const { organizationId } = useParams<RouteProps>();
  const [applications, setApplications] = useState<GameApplication[]>([]);
  const [loading, setLoading] = useState(false);

  async function getApplications() {
    setLoading(true);
    try {
      const result = await RBACClient.getGameApplicationsByCompany(new Id({ id: organizationId }));
      setApplications(result.gameApplications);
    } catch {
    } finally {
      setLoading(false);
    }
  }

  const getApplicationsCallback = useCallback(getApplications, [organizationId]);

  useEffect(() => {
    getApplicationsCallback();
  }, [getApplicationsCallback, organizationId]);

  return (
    <EntityList<GameApplication>
      loading={loading}
      columns={[
        'Game Name',
        'Game ID',
        'Requesting Organization',
        'Owning Organization',
        'Date Created',
        'Twitch Directory Link',
        'IGDB/GB Link',
      ]}
      items={applications}
      rowType={GameReviewListItem}
      rowProps={{}}
      zeroStateMessage="No Game Application found"
      header={{}}
    />
  );
};
