import React from 'react';
import { Layout, Tabs, JustifyContent } from 'twitch-core-ui';
import { PageHeader } from '~features/page-header';
import { useLocation } from 'react-router';

export const OrganizationRootEntry: React.FC = (props) => {
  const location = useLocation();

  function determineTab() {
    switch (location.pathname) {
      case '/organizations':
        return 0;
      case '/organizations/review':
        return 1;
      default:
        return 0;
    }
  }

  return (
    <>
      <PageHeader
        title="Organizations"
        subtitle="Manage and review organizations using the options below"
      />
      <Layout margin={{ bottom: 4 }}>
        <Tabs
          tabs={[
            {
              label: 'Management',
              linkTo: '/organizations',
            },
            {
              label: 'Review',
              linkTo: '/organizations/review',
            },
          ]}
          activeTabIndex={determineTab()}
          justifyContent={JustifyContent.Start}
        />
      </Layout>
      {props.children}
    </>
  );
};
