import React from 'react';
import { Layout } from 'twitch-core-ui';
import { Switch, Route } from 'react-router';
import { OrganizationListPage } from '~pages/organization-list';
import { OrganizationReviewListPage } from '~pages/organization-review-list';
import { OrganizationRootEntry } from '~pages/organization-root/organization-root-entry';
import { OrganizationReviewDetailPage } from '~pages/organization-review-detail';
import { OrganizationDetailPage } from '~pages/organization-detail';
import { withAuthorization, UnauthorizedBehavior } from '~core/components/with-authorization';
import { ViennaLDAPRoles } from '~core/components/with-authorization/roles';

export interface PublicProps {}

type Props = PublicProps;

export const OrganizationRootPageComponent: React.FC<Props> = () => {
  return (
    <Layout margin={2} fullHeight>
      <Layout>
        <Switch>
          <Route
            path="/organizations/review/:applicationId([0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[0-9a-f]{4}-[0-9a-f]{12})"
            component={OrganizationReviewDetailPage}
            exact
          />
          <Route
            path="/organizations/:organizationId([0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[0-9a-f]{4}-[0-9a-f]{12})"
            component={OrganizationDetailPage}
          />
          <OrganizationRootEntry>
            <Route path="/organizations/review" component={OrganizationReviewListPage} exact />
            <Route path="/organizations" component={OrganizationListPage} exact />
          </OrganizationRootEntry>
        </Switch>
      </Layout>
    </Layout>
  );
};

export const OrganizationRootPage = withAuthorization({
  role: ViennaLDAPRoles.BaseAccess,
  behavior: UnauthorizedBehavior.Redirect,
})(OrganizationRootPageComponent);
