import React from 'react';
import {
  Table,
  TableHeading,
  TableRow,
  TableBody,
  TableHeader,
  StyledLayout,
  Background,
  Display,
  JustifyContent,
  AlignItems,
  Layout,
  Pagination,
  PaginationMouseEvent,
} from 'twitch-core-ui';
import { OrganizationUserItem } from '~features/organization-users/organization-user-item';
import { Membership } from '~core/clients/rbac/code.justin.tv.devrel';
import { UserInformation } from '~features/organizations/models/user-information';
import { PaginationProps } from '~features/hooks/use-pagination';

export interface PublicProps {
  members: Membership[];
  onRemoveUser: (userId: string) => void;
  onUpdateUser: (user: UserInformation) => void;
  pagination: PaginationProps;
}

type Props = PublicProps;

export const OrganizationUsersPresentation: React.FC<Props> = (props) => {
  if (!props.members.length) {
    return (
      <StyledLayout
        background={Background.Alt2}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
        alignItems={AlignItems.Center}
        padding={{ y: 4 }}
      >
        This Organization has no Members
      </StyledLayout>
    );
  }

  return (
    <>
      <Layout display={Display.Flex} justifyContent={JustifyContent.End} margin={{ bottom: 1 }}>
        <Pagination
          currentPage={props.pagination.currentPage}
          totalPages={props.pagination.totalPages}
          previousPageButtonAriaLabel="Previous"
          nextPageButtonAriaLabel="Next"
          onClickNext={props.pagination.onNextPage}
          onClickPrevious={props.pagination.onPreviousPage}
          onClickIndex={(index: PaginationMouseEvent<HTMLDivElement>) =>
            props?.pagination?.onGoToPage(index.goToPage)
          }
        />
      </Layout>
      <Table>
        <TableHeader>
          <TableRow>
            <TableHeading>User</TableHeading>
            <TableHeading>Name</TableHeading>
            <TableHeading>Title</TableHeading>
            <TableHeading>Role</TableHeading>
            <TableHeading>Email</TableHeading>
            <TableHeading>Date Created</TableHeading>
            <TableHeading>Actions</TableHeading>
          </TableRow>
        </TableHeader>
        <TableBody>
          {props.members.map((member, index) => (
            <OrganizationUserItem
              member={member}
              key={index}
              onRemoveUser={props.onRemoveUser}
              onUpdateUser={props.onUpdateUser}
            />
          ))}
        </TableBody>
      </Table>
    </>
  );
};
