import React from 'react';
import {
  Layout,
  Display,
  JustifyContent,
  AlignItems,
  FlexDirection,
  Title,
  Button,
} from 'twitch-core-ui';
import { useHistory } from 'react-router';

export const UnauthorizedPage: React.FC = () => {
  const history = useHistory();

  function onBack() {
    history.goBack();
  }

  return (
    <Layout
      fullHeight
      fullWidth
      display={Display.Flex}
      justifyContent={JustifyContent.Center}
      alignItems={AlignItems.Center}
    >
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        alignItems={AlignItems.Center}
        justifyContent={JustifyContent.Center}
      >
        <Layout margin={{ bottom: 2 }}>
          <Title>You're not authorized to view this page</Title>
        </Layout>
        <Button onClick={onBack}>Back</Button>
      </Layout>
    </Layout>
  );
};
