# RBAC service for companies, developers, resources and roles.

Environments:

- Production: https://prod.devsite-rbac.twitch.a2z.com
- Staging: https://staging.devsite-rbac.twitch.a2z.com

RBAC stands for "Role Based Access Control", an approach to restricting system access to authorized users. However RBAC evolved over time to be more focused on specific use cases for Twitch Developers (http://dev.twitch.tv):

- Validate user access on RBAC resources (`ValidateByTwitchID`).
- Manage companies (organizations)
- Manage company memberships: add users with a given role, remove users, list users, etc.
- Manage company resources: games, extensions, etc.
- Create JWT for VHS (for drops campaign creation, called by Visage).
- Backend for [Vienna](https://git-aws.internal.justin.tv/devrel/vienna), the admin interface for reviews, companies and roles.

## Contributing

- When contributing please make sure to submit your PR to the `develop` branch.
- [How to Deploy](#Deploy)
- [I need to change the infrastructure](#Infrastructure)

## Local Development

- Install tools and update dependencies: `make setup` (may require brew install go and dep first).
- Install `mwinit` and `ada` AWS credentials to our account: `https://wiki.twitch.com/display/AD/Using+Isengard+from+the+command+line+or+programatically` (Preparation and Option 2).
- [Install the AWS CLI](https://docs.aws.amazon.com/cli/latest/userguide/install-cliv2.html) if you are missing it to run RBAC with staging and production configuration locally.
- Install [Docker](https://docs.docker.com/docker-for-mac/install/)
- Start the server in your localhost. Using staging DB and clients: `make run_staging`. Or setup the local DB and then `make run_local`. See [docs/database](./docs/database.md)
- Run e2e (End to End) tests: `make e2e`. Or inside Docker like the ci server (Jenkins): `make e2e_ci`. See [docs/e2e](./docs/e2e.md)

### Go dep

To import a new Golang package dependency: `dep ensure -add <pkg>/<subpkg>`, then add (or edit) the dependecy in the `Gopkg.toml` file without the subpkg. For example `dep ensure -add code.justin.tv/web/owl/client`, and then add to `Gopkg.toml` a `[[constaint]]` with `name = "code.justin.tv/web/owl"` and `revision = "7b41e5298ced8e9760497d624e1f6923f2f00725"` (please use version or revisions, avoid branch). To finalize, use the import in code, and then run `dep ensure --vendor-only`. The vendor folder should be updated to contain the subpackages that are being used.

### Command line tools

Tools (code generation, etc.) are managed via [retool](github.com/twitchtv/retool). Tools (linters, etc.) are managed via `dep` and `required` ([docs here](https://golang.github.io/dep/docs/Gopkg.toml.html#required)).

The `_tools` folder is ignored, not checked in the repo, because the tools are not used in CI and to avoid ugly diffs on PR code reviews. Linters and other tools needed during CI are put into `vendor` and it can be run with `go run ./vendor/path/to/cmd`.

When adding a new tool, use `retool add` and then add a new `make` task to the `Makefile`. Prefix the task command with `retool do`, so everyone runs the same version. When adding a new linter, add it to `required` in `Gopkg.toml` and run `dep ensure`. When updating a tool, change the `revision` of it in `Gopkg.lock` and run `dep ensure --vendor-only`.

### Environment Configuration

The RBAC service requires the environment variable `ENVIRONMENT` to decide the file to load from `config/env-<ENVIRONMENT>.toml`. All the variables dependent on environemnt are defined in those files.

It is not possible to override values through other environment variables or flags. This is to simplify tracing down what values are used in production; what you see in the file is what it is being used (see PR https://git-aws.internal.justin.tv/devrel/devsite-rbac/pull/177 for more details on this reasoning). However, a configuration file can extend and override some values in another configuration file by setting the `EXTENDS` property, for example `config/env-local-production.toml`.

See `make run_staging` and similar tasks for examples on how to start the service. If you want to test a custom configuration without adding it to the repo, any file named `config/env-custom*` is git-ignored.

### Secrets

Passwords and access keys can not be stored in the config files that live in Github.
[AWS Secret Manager](https://us-west-2.console.aws.amazon.com/secretsmanager/home) is used to securely manage secrets.

### Static Code Analysis

To run static code analysis you will first need to download [Sonar Scanner](https://docs.sonarqube.org/latest/analysis/scan/sonarscanner/). You will need to unzip and move it to a directory you want then add the bin dirctory to your PATH. Next you will need to setup the sonar properties file located at \$install_directory/conf/sonar-scanner.properties. To setup the file follow the "Procedure" steps [here](https://wiki.twitch.com/display/SEC/Enable+Security+Static+Analysis%3A+Other). After Sonar Scanner is installed you can run `make static_analysis` to run the code analysis and send the report up to Appsec (http://codeanalysis.security.xarth.tv) and you can review the results under the RBAC project.

## Infrastructure

Infrastructure for RBAC is now handled via AWS-CDK. You can find more details on how to setup CDK in the [Infra](/infra) folder located inside this repo

### How to deploy infrastructure changes

Any changes that need to be tested can be deployed to staging IF they are non-breaking (adding in a new environment variable, ect). Please be sure to run `npx cdk diff "StackName"` before deploying to ensure someone else is not in works on that system and that you are not about to deploy over someone elses code. While working in your branch you should make sure you are always up to date with develop/master so you are not deploying old code to staging. If you are unsure or believe your change is breaking please reach out to a maintainer to review and or deploy the code to staging for you. We can deploy straight from your PR as long as it is up to date.

To deploy to Production please open a PR with your changes, for the body of the PR include the DIFF for production as well as your end goal so that the reviewer can see any changes that will be made. This can be done by running `npx cdk diff "Prod*"` in the repo.

## Deploy

We recently changed our deploy process to utilize pipelines inside the respective accounts. Merging your branch to develop will automatically deploy it to staging. Merging into master will trigger a build/deploy for production but will require manual approve before it finishes the deploy. Please reach out to a maintainer to approve production deploys.

Note: These links assume you have Isengard access to the accounts

[Development Pipeline](https://isengard.amazon.com/federate?account=059023621032&role=admin&destination=codesuite%2Fcodepipeline%2Fpipelines%2FRbac-Deploy-Staging%2Fview%3Fregion%3Dus-west-2%23)

[Production Pipeline](https://isengard.amazon.com/federate?account=712827439730&role=admin&destination=codesuite%2Fcodepipeline%2Fpipelines%2FRbac-Deploy-Production%2Fview%3Fregion%3Dus-west-2%23)

### Need to deploy a specific branch

See [How to deploy non-standard branches](/docs/deploy.md)

## More Docs

Check the [docs folder](/docs).
