package common

import (
	"context"
	"database/sql"

	"code.justin.tv/devrel/dbx"
	"github.com/Masterminds/squirrel"
	"github.com/jmoiron/sqlx"
)

// DBXer is the interface implemented by DBX. Used to wrap errx and fakes for tests.
//go:generate counterfeiter . DBXer
//go:generate errxer DBXer
type DBXer interface {
	LoadOne(ctx context.Context, dest interface{}, q squirrel.SelectBuilder) error
	LoadAll(ctx context.Context, dest interface{}, q squirrel.SelectBuilder) error

	InsertOne(ctx context.Context, table string, values interface{}, setOpt ...dbx.FieldsOpt) error
	UpdateOne(ctx context.Context, table string, values interface{}, setOpt ...dbx.FieldsOpt) error
	DeleteOne(ctx context.Context, table string, values interface{}, setOpt ...dbx.FieldsOpt) error

	NamedExec(ctx context.Context, namedSQL string, values interface{}) (sql.Result, error)
	NamedExecOne(ctx context.Context, namedSQL string, values interface{}) error

	DBOrTx(ctx context.Context) sqlx.Ext
}
