package common

import (
	"code.justin.tv/devrel/dbx"
	"code.justin.tv/devrel/devsite-rbac/config"
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/jmoiron/sqlx"
)

func MustConnectDBX(c *config.RBAC, stats statsd.Statter) DBXer {
	sqlxDB := MustConnectPostgresSQLX(c)
	dbxDB := &dbx.DBX{DB: sqlxDB}
	errxWrapper := &DBXerErrx{DBXer: dbxDB}
	return errxWrapper
}

func MustConnectPostgresSQLX(c *config.RBAC) *sqlx.DB {
	db := sqlx.MustConnect("postgres", PostgresConnStr(c))
	db.DB.SetMaxIdleConns(2)
	db.DB.SetMaxOpenConns(50)
	return db
}

func PostgresConnStr(c *config.RBAC) string {
	sslmode := "disable"
	if c.PGSSLEnabled {
		sslmode = "require"
	}
	return "host=" + c.PGHost +
		" port=" + c.PGPort +
		" user=" + c.PGUser +
		" password=" + c.PGPassword +
		" dbname=" + c.PGDBName +
		" sslmode=" + sslmode +
		" statement_timeout=2000" // 2 seconds
}
