package companyapplications

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

type SecureBackend struct {
	CompanyApplications
}

func (b *SecureBackend) ListCompanyApplications(ctx context.Context, params *rbacrpc.ListCompanyApplicationsRequest) ([]CompanyApplication, int32, error) {
	list, total, err := b.CompanyApplications.ListCompanyApplications(ctx, params)
	secureList := []CompanyApplication{}
	for _, capp := range list {
		FilterSecureData(ctx, &capp)
		secureList = append(secureList, capp)
	}
	return secureList, total, err
}

func (b *SecureBackend) SearchCompanyApplications(ctx context.Context, query string, limit uint64) ([]CompanyApplication, int32, error) {
	list, total, err := b.CompanyApplications.SearchCompanyApplications(ctx, query, limit)
	secureList := []CompanyApplication{}
	for _, capp := range list {
		FilterSecureData(ctx, &capp)
		secureList = append(secureList, capp)
	}
	return secureList, total, err
}

func (b *SecureBackend) GetCompanyApplication(ctx context.Context, id string) (CompanyApplication, error) {
	capp, err := b.CompanyApplications.GetCompanyApplication(ctx, id)
	FilterSecureData(ctx, &capp)
	return capp, err
}

func FilterSecureData(ctx context.Context, capp *CompanyApplication) {
	if auth.IsUserSecure(ctx) {
		return
	}

	capp.ContactFirstName = ""
	capp.ContactLastName = ""
	capp.ContactEmail = ""
}
