package companyresources

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/cactus/go-statsd-client/statsd"
)

//go:generate counterfeiter . CRBackender
//go:generate errxer --timings CRBackender
type CRBackender interface {
	InsertResource(ctx context.Context, params *ResourceType) error
	DeleteResource(ctx context.Context, params *ResourceType) error
	DeleteResourcesByCompany(ctx context.Context, companyID string) error
	FindResources(ctx context.Context, companyID, resourceType, resourceID string, limit, offset uint64) ([]ResourceType, int, error)
	FindCompaniesWithResource(ctx context.Context, externalID, resourceType string) ([]*rbacrpc.Company, error)
}

const Table = "company_resources"

type ResourceType struct {
	ExternalId string `db:"resource_id"`
	Type       string `db:"resource_type"`
	// Resources can only be owned by one company right now.
	CompanyID string `db:"company_id"`

	XXX_Total int32 `db:"_total"`
}

func (rt ResourceType) ToRPC() *rbacrpc.Resource {
	return &rbacrpc.Resource{
		ExternalId: rt.ExternalId,
		Type:       rt.Type,
	}
}

func New(db common.DBXer, stats statsd.Statter) *CRBackenderErrx {
	return &CRBackenderErrx{
		CRBackender: &backend{db: db},
		TimingFunc:  common.TimingStats(stats),
	}
}

type backend struct {
	db common.DBXer
}
