package companyresources

import (
	"context"
	"fmt"

	"code.justin.tv/devrel/dbx"
)

func (b *backend) DeleteResource(ctx context.Context, params *ResourceType) error {
	return b.db.DeleteOne(ctx, "company_resources", params, dbx.FindBy("resource_id", "resource_type", "company_id"))
}

func (b *backend) DeleteResourcesByCompany(ctx context.Context, companyID string) error {
	cr := ResourceType{
		CompanyID: companyID,
	}

	_, err := b.db.NamedExec(ctx, fmt.Sprintf("DELETE FROM %s WHERE company_id = :company_id", Table), cr)

	return err
}
