package companyresources

import (
	"context"

	"github.com/Masterminds/squirrel"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
)

func (b *backend) FindResources(ctx context.Context, companyID, resourceType, resourceID string, limit, offset uint64) ([]ResourceType, int, error) {
	byCompanyResourceType := func(selectBuilder squirrel.SelectBuilder) squirrel.SelectBuilder {
		if companyID != "" {
			selectBuilder = selectBuilder.Where("company_id = ?", companyID)
		}
		if resourceType != "" {
			selectBuilder = selectBuilder.Where("resource_type = ?", resourceType)
		}
		if resourceID != "" {
			selectBuilder = selectBuilder.Where("resource_id = ?", resourceID)
		}

		return selectBuilder
	}

	var resourceTypes []ResourceType
	q := common.PSQL.Select(common.CountOverAs("_total"), "resource_id", "resource_type", "company_id").
		From("company_resources")
	q = byCompanyResourceType(q)
	q = common.Paginate(q, limit, offset)

	err := b.db.LoadAll(ctx, &resourceTypes, q)
	if err != nil {
		return nil, -1, err
	}

	return resourceTypes, int(common.FirstRowInt32DBField(resourceTypes, "_total")), nil
}
