package featuregating

import (
	"database/sql"

	"code.justin.tv/devrel/dbx"
	"github.com/lib/pq"
)

const Table = "feature_gating"

const (
	featureGatingKeyCol            = "feature_gating_key"
	featureGatingKeyEquation       = "feature_gating_key = ?"
	featureGatingValueInBoolCol    = "feature_gating_value_in_bool"
	featureGatingValueInStringsCol = "feature_gating_value_in_strings"
)

type FeatureGatingRow struct {
	FeatureGatingKey            string         `db:"feature_gating_key"`
	FeatureGatingValueInBool    sql.NullBool   `db:"feature_gating_value_in_bool"`
	FeatureGatingValueInStrings pq.StringArray `db:"feature_gating_value_in_strings"`
}

var Columns = dbx.FieldsFrom(FeatureGatingRow{})
