package gameapplications

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (b *backend) FindGameApplicationsByCompany(ctx context.Context, id string) (*rbacrpc.GetGameApplicationsByCompanyResponse, error) {
	var gameApplications []GameApplication
	err := b.db.LoadAll(ctx, &gameApplications, b.selectGameApplicationsByCompanyQuery(id))
	if err != nil {
		return nil, err
	}

	return &rbacrpc.GetGameApplicationsByCompanyResponse{
		GameApplications: listToRPC(gameApplications),
		XTotal:           common.FirstRowInt32DBField(gameApplications, "_total"),
	}, nil
}
