package gameapplications

import (
	"github.com/Masterminds/squirrel"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

var (
	Cols = []string{
		IDCol,
		GameIDCol,
		CompanyCol,
		CreatedAtCol,
	}
)

const (
	Table        = "game_applications"
	IDCol        = "id"
	GameIDCol    = "game_id"
	CompanyCol   = "company_id"
	CreatedAtCol = "created_at"
)

type GameApplication struct {
	ID        string `db:"id"`
	GameID    int32  `db:"game_id"`
	CompanyID string `db:"company_id"`
	CreatedAt string `db:"created_at"`

	XXX_Total int32 `db:"_total"`
}

func (a GameApplication) toRPC() *rbacrpc.GameApplication {
	return &rbacrpc.GameApplication{
		Id:        a.ID,
		GameId:    a.GameID,
		CompanyId: a.CompanyID,
		CreatedAt: a.CreatedAt,
	}
}

func listToRPC(list []GameApplication) []*rbacrpc.GameApplication {
	gas := make([]*rbacrpc.GameApplication, len(list))
	for i, ga := range list {
		gas[i] = ga.toRPC()
	}

	return gas
}

func (b *backend) selectGameApplicationQuery(id string) squirrel.SelectBuilder {
	return common.PSQL.Select(Cols...).
		From(Table).
		Where(squirrel.Eq{IDCol: id})
}

func (b *backend) selectGameApplicationsQuery(params *rbacrpc.ListGameApplicationsRequest) squirrel.SelectBuilder {
	cols := append(Cols, "count(*) OVER() as _total")
	q := common.PSQL.Select(cols...).
		From(Table).Limit(params.Limit).Offset(params.Offset).OrderBy(CreatedAtCol)

	if params.GameId > 0 {
		q = q.Where(squirrel.Eq{GameIDCol: params.GameId})
	}

	if params.CompanyId != "" {
		q = q.Where(squirrel.Eq{CompanyCol: params.CompanyId})
	}

	return q
}

func (b *backend) selectGameApplicationsByCompanyQuery(id string) squirrel.SelectBuilder {
	cols := append(Cols, "count(*) OVER() as _total")
	return common.PSQL.Select(cols...).
		From(Table).Where(squirrel.Eq{CompanyCol: id}).OrderBy(CreatedAtCol)
}
