package gameapplications

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

// SelectGameApplicationByGameId returns a GameApplication if found, or nil if not found.
// An error is returned if there was an internal issue with the connection or the query.
func (b *backend) SelectGameApplicationByGameId(ctx context.Context, gameId int32) (*rbacrpc.GameApplication, error) {
	listResp, err := b.FindGameApplications(ctx, &rbacrpc.ListGameApplicationsRequest{
		GameId: gameId,
		Limit:  1,
	})
	if errorutil.IsErrNoRows(err) {
		return nil, nil // not found
	}
	if err != nil {
		return nil, err // internal error
	}

	if len(listResp.GameApplications) >= 1 {
		gameApp := listResp.GameApplications[0]
		return gameApp, nil // found
	}

	return nil, nil // not found
}
