package testutils

import (
	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

const (
	owner         = "Owner"
	administrator = "Administrator"
	manager       = "Manager"
	developer     = "Developer"
	marketer      = "Marketer"
)

func MockMembership(role string) *rbacrpc.Membership {
	return &rbacrpc.Membership{
		// UserId:     "",
		TwitchId:   common.NewUUID(),
		CompanyId:  common.NewUUID(),
		DevTitle:   "Developer",
		CreatedAt:  "2018-05-24 13:39:31.36",
		ModifiedAt: "2018-08-24 16:23:18.30",
		LastName:   "test_last_name",
		FirstName:  "test_first_name",
		DevEmail:   "testemail@test.com",
		Role:       role,
	}
}

func MockGetUsersByCompanyIdResponse(companyId string) *rbacrpc.GetUsersByCompanyIdResponse {
	return &rbacrpc.GetUsersByCompanyIdResponse{
		Id: companyId,
		Memberships: []*rbacrpc.Membership{
			MockMembership(administrator),
			MockMembership(administrator),
			MockMembership(administrator),
			MockMembership(manager),
			MockMembership(marketer),
			MockMembership(developer),
			MockMembership(owner),
		},
		Total: 6,
	}
}

func MockCompany() *rbacrpc.Company {
	return &rbacrpc.Company{
		Id:                common.NewUUID(),
		CompanyName:       "test_Company",
		Url:               "https://testcom.com",
		Type:              2,
		VhsContractSigned: true,
		CampaignsEnabled:  true,
		Identifier:        "testcom",
		CurseCompanyId:    -1,
		CreatedAt:         "2018-12-05 23:17:18",
		Legacy:            false,
	}
}

func MockDeveloperApplication(companyId string, twitchId string) *rbacrpc.DeveloperApplication {
	tId := twitchId
	if tId == "" {
		tId = common.NewUUID()
	}
	cId := companyId
	if cId == "" {
		cId = common.NewUUID()
	}
	devApp := &rbacrpc.DeveloperApplication{
		Id:        common.NewUUID(),
		CompanyId: cId,
		TwitchId:  tId,
		Title:     "Developer",
		CreatedAt: "2019-03-25 10:29:47",
		FirstName: "test_first_name",
		LastName:  "test_last_name",
		Email:     "test@test.com",
	}
	return devApp
}
