package cartman

import "context"

// NoopClient implements the interface as a NOOP,
// to provide predictable results in a test environment.
type NoopClient struct{}

// GetToken NOOP returns a fake token.
func (c *NoopClient) GetToken(ctx context.Context, oauthToken, capabilities string, authFnParams map[string]string) (string, error) {
	return "faketoken", nil
}
