package cryptionclient_test

import (
	"encoding/base64"
	"testing"

	"code.justin.tv/devrel/devsite-rbac/clients/cryptionclient"
	"code.justin.tv/devrel/devsite-rbac/clients/kmsclient/kmsclientfakes"
	"github.com/aws/aws-sdk-go/service/kms"
	"github.com/stretchr/testify/require"
)

func TestEncryptionAndDecryption(t *testing.T) {
	fakeKMSClient := &kmsclientfakes.FakeKmsClient{}
	cryptionClient := &cryptionclient.Client{
		KmsClient: fakeKMSClient,
	}
	mockKeyId := "arn:aws:kms:us-west-2:059023621032:key/5a24e05c-6fa1-476d-b28a-81d97cc56c88"
	mockCiphertextBlob, err := base64.StdEncoding.DecodeString("AQIDAHiarT79fhK9NmeIXqXgRyaph7nkKRSZ+m6J5+AiHHZPDQHBoACd1B3i5m8tMeeMEIPNAAAAfjB8BgkqhkiG9w0BBwagbzBtAgEAMGgGCSqGSIb3DQEHATAeBglghkgBZQMEAS4wEQQMjzDG6egI/GFnClGTAgEQgDvS4zri1czDA2vMhoW6UPnKP0L6npYirjKg0+kW7tShOVp+NrY3CeLSOv23JEqF1OIcjdbaCRtxh9ieVA==")
	require.NoError(t, err)
	mockPlainText, err := base64.StdEncoding.DecodeString("8RxYuTvMYzO4XfH1+9MmzOhYwYLRf3iQcGgQnOa5Ajw=")
	require.NoError(t, err)
	mockGenerateDataKeyOutput := &kms.GenerateDataKeyOutput{
		KeyId:          &mockKeyId,
		CiphertextBlob: mockCiphertextBlob,
		Plaintext:      mockPlainText,
	}

	fakeKMSClient.GenerateDataKeyReturns(mockGenerateDataKeyOutput, nil)

	mockDecryptOutput := &kms.DecryptOutput{
		KeyId:     &mockKeyId,
		Plaintext: mockPlainText,
	}

	fakeKMSClient.DecryptReturns(mockDecryptOutput, nil)

	testString := "This is a test string"
	encryptedDataKey, cipherText, err := cryptionClient.EncryptPlainText([]byte(testString))
	require.NotEqual(t, testString, string(cipherText))
	require.NoError(t, err)
	decryptedString, err := cryptionClient.DecryptPlainText(encryptedDataKey, cipherText)
	require.NoError(t, err)
	require.Equal(t, testString, decryptedString)
}
